/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.network.FabricNetworkHandler;
import potionstudios.byg.network.packet.BYGS2CPacket;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.world.biome.BYGFabricEndBiomeSource;
import potionstudios.byg.world.biome.BYGFabricNetherBiomeSource;

@AutoService(value={ModPlatform.class})
public class FabricModPlatform
implements ModPlatform {
    @Override
    public Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("byg");
    }

    @Override
    public boolean isModLoaded(String isLoaded) {
        return FabricLoader.getInstance().isModLoaded(isLoaded);
    }

    @Override
    public <P extends BYGS2CPacket> void sendToClient(class_3222 player, P packet) {
        FabricNetworkHandler.sendToPlayer(player, packet);
    }

    @Override
    public BYGNetherBiomeSource createNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        return new BYGFabricNetherBiomeSource(biomeRegistry, seed);
    }

    @Override
    public BYGEndBiomeSource createEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        return new BYGFabricEndBiomeSource(biomeRegistry, seed);
    }

    @Override
    public String tagNameSpace() {
        return "c";
    }

    @Override
    public boolean isClientEnvironment() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public ModPlatform.Platform modPlatform() {
        return ModPlatform.Platform.FABRIC;
    }

    @Override
    public boolean hasLoadErrors() {
        return false;
    }

    @Override
    public String curseForgeURL() {
        return "https://www.curseforge.com/minecraft/mc-mods/oh-the-biomes-youll-go-fabric/files";
    }
}

